

<?php $__env->startSection('title', 'Doctor Profile'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6 gap-4">
        <h1 class="text-3xl font-bold text-gray-800">My Profile</h1>
        <div class="flex gap-2">
            <a href="<?php echo e(route('doctor.dashboard')); ?>" class="bg-gray-600 hover:bg-gray-700 text-white px-4 py-2 rounded">
                <i class="fas fa-home mr-2"></i>Dashboard
            </a>
            <a href="<?php echo e(route('doctor.availability')); ?>" class="bg-purple-600 hover:bg-purple-700 text-white px-4 py-2 rounded">
                <i class="fas fa-calendar-alt mr-2"></i>Manage Availability
            </a>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <form method="POST" action="<?php echo e(route('doctor.profile.update')); ?>" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Title</label>
                    <input type="text" name="title" value="<?php echo e($doctor->title); ?>" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">First Name *</label>
                    <input type="text" name="first_name" value="<?php echo e($doctor->first_name); ?>" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Last Name *</label>
                    <input type="text" name="last_name" value="<?php echo e($doctor->last_name); ?>" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Practice Number *</label>
                    <input type="text" name="practice_number" value="<?php echo e($doctor->practice_number); ?>" required class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Specialization</label>
                    <input type="text" name="specialization" value="<?php echo e($doctor->specialization); ?>" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Qualification</label>
                    <input type="text" name="qualification" value="<?php echo e($doctor->qualification); ?>" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Phone</label>
                    <input type="text" name="phone" value="<?php echo e($doctor->phone); ?>" class="w-full px-3 py-2 border rounded">
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Country</label>
                    <input type="text" name="country" value="<?php echo e($doctor->country); ?>" class="w-full px-3 py-2 border rounded">
                </div>

                <div class="md:col-span-2">
                    <label class="block text-gray-700 text-sm font-bold mb-2">Educational Details</label>
                    <textarea name="educational_details" rows="3" class="w-full px-3 py-2 border rounded"><?php echo e($doctor->educational_details); ?></textarea>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Profile Picture</label>
                    <input type="file" name="profile_picture" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <?php if($doctor->profile_picture_path): ?>
                        <p class="text-sm text-gray-600 mt-1">Current: <img src="<?php echo e(asset('storage/' . $doctor->profile_picture_path)); ?>" alt="Profile" class="w-20 h-20 rounded-full mt-2"></p>
                    <?php endif; ?>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Letterhead</label>
                    <input type="file" name="letterhead" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <?php if($doctor->letterhead_path): ?>
                        <p class="text-sm text-gray-600 mt-1">Current: <a href="<?php echo e(asset('storage/' . $doctor->letterhead_path)); ?>" target="_blank">View</a></p>
                    <?php endif; ?>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Stamp</label>
                    <input type="file" name="stamp" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <?php if($doctor->stamp_path): ?>
                        <p class="text-sm text-gray-600 mt-1">Current: <a href="<?php echo e(asset('storage/' . $doctor->stamp_path)); ?>" target="_blank">View</a></p>
                    <?php endif; ?>
                </div>

                <div>
                    <label class="block text-gray-700 text-sm font-bold mb-2">Signature</label>
                    <input type="file" name="signature" accept="image/*" class="w-full px-3 py-2 border rounded">
                    <?php if($doctor->signature_path): ?>
                        <p class="text-sm text-gray-600 mt-1">Current: <a href="<?php echo e(asset('storage/' . $doctor->signature_path)); ?>" target="_blank">View</a></p>
                    <?php endif; ?>
                </div>
            </div>

            <div class="mt-6">
                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-2 rounded">
                    Update Profile
                </button>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\BrainTech\Documents\BEAUTEZ SYSTEM\resources\views/doctor/profile.blade.php ENDPATH**/ ?>